<?php
/* -----------------------------------------------------------------------------
-- Contact Form Handler
----------------------------------------------------------------------------- */

// Site Email
$myemail = 'service@waterheatermansfield.com';
$secret_key = '6LddJ9gUAAAAANGePX4g3oUXCae7XKsB3iBRJ7OF';

/* -----------------------------------------------------------------------------
-- Handler Variables
----------------------------------------------------------------------------- */

$errors = $name = $email = $phone = $message = $city = $service = $services = '';

/* -----------------------------------------------------------------------------
-- Set values
----------------------------------------------------------------------------- */

if(isset($_POST['g-recaptcha-response'])){ $captcha = $_POST['g-recaptcha-response'];}
if(isset($_POST['name'])){ $name = removeurl($_POST['name']);}
if(isset($_POST['email'])){ $email = $_POST['email'];}
if(isset($_POST['tele'])){ $phone = $_POST['tele'];}
if(isset($_POST['special_request'])){ $message = removeurl($_POST['special_request']);}
if(isset($_POST['city'])){ $city = $_POST['city'];}
if(isset($_POST['service'])){ $services = $_POST['service'];}

/* -----------------------------------------------------------------------------
-- Check values
----------------------------------------------------------------------------- */


if(!$captcha){
  $errors .= "\n Error: You Missed The Captcha, Check it Please!.";
}

if( !is_valid($name) || !is_valid($email) || !is_valid($phone) ){
  $errors .= "\n Error: Name, Email or Phone is Missing.";
}

if( !is_email($email) ){
  $errors .= "\n Error: Invalid email address";
}

/*
if( !valid_phone($phone) ){
  $errors .= "\n Error: Please ensure that the phone number is written correctly";
}
*/

/* -----------------------------------------------------------------------------
-- Check values
----------------------------------------------------------------------------- */

if( empty($errors)){

  $handle = curl_init('https://www.google.com/recaptcha/api/siteverify');
  curl_setopt($handle, CURLOPT_POST, true);
  curl_setopt($handle, CURLOPT_POSTFIELDS, "secret=$secret_key&response=$captcha");
  curl_setopt($handle, CURLOPT_RETURNTRANSFER, true);
  $response = curl_exec($handle);
  $explodedArr = explode(",",$response);
  $doubleExplodedArr = explode(":",$explodedArr[0]);
  $captchaConfirmation = end($doubleExplodedArr);
  //print_r($doubleExplodedArr);
  if ( trim($captchaConfirmation) == "true" ) {


    $subject = truncate($message, 5, 42);
    if ( !is_valid($subject) ){ $subject = $name; }
    $email_body = " \n From:\n
    Name : $name \n
    Contact Number : $phone \n
    Email Address : $email \n
    City : $city \n
    Special Request : \n $message \n";

    $headers = "From: $myemail\n";
  	$headers .= "Reply-To: $email";

    $result = mail($myemail,$subject,$email_body,$headers);
    if(!$result) {
      $errors .= "\n Error: Something went wrong. Please try again";
    } else {
      header('Location: contact-form-thank-you.html');
    }



  } else {
    $errors .= "\n Error: You seem to be doing something wrong, you were banned by the system";
  }


}

/* -----------------------------------------------------------------------------
-- Check values
----------------------------------------------------------------------------- */





/* -----------------------------------------------------------------------------
-- My Functions
----------------------------------------------------------------------------- */

// Validatr Variables
function is_valid($var){
  if( isset($var) && !empty($var) && $var !== '' ){
    return true;
  } else {
    return false;
  }
}

// Validatr Emails
function is_email($var){
  if (filter_var($var, FILTER_VALIDATE_EMAIL)) {
    return true;
  } else {
    return false;
  }
}

// subject function
function truncate($input, $maxWords, $maxChars){
  $words = preg_split('/\s+/', $input);
  $words = array_slice($words, 0, $maxWords);
  $words = array_reverse($words);
  $chars = 0;
  $truncated = array();
  while(count($words) > 0)
  {
    $fragment = trim(array_pop($words));
    $chars += strlen($fragment);
    if($chars > $maxChars) break;
    $truncated[] = $fragment;
  }
  $result = implode($truncated, ' ');
  if ($input == $result){
    return $input;
  }
  else{
    return preg_replace('/[^\w]$/', '', $result) ;
  }
}

// Remove Links
function removeurl($var){
  $regex = "@(https?://([-\w\.]+[-\w])+(:\d+)?(/([\w/_\.#-]*(\?\S+)?[^\.\s])?).*$)@";
  return preg_replace($regex, ' ', $var);
}

function valid_phone($var){
  $formats = array(
      '###-###-####', '####-###-###',
      '(###) ###-###','####-####-####',
      '##-###-####-####','####-####','###-###-###',
      '#####-###-###', '##########', '#########',
      '# ### #####', '#-### #####'
   );
   $format = trim(preg_replace('/[0-9]/', '#', $var));
   return (in_array($format, $formats)) ? true : false;
}

?>
<!DOCTYPE html>
<html>
<head>
	<title>Contact form handler</title>
  <style>
  body{
    background-color: #E6E6E6;
    font-size: 10pt;
    padding-top: 50px;
    text-align: left;
  }
  a {
    color: #666;
    text-decoration: none;
  }
  a:hover {
    text-decoration: underline;
  }
  .container {
    margin: auto;
    max-width: 540px;
    min-width: 200px;
  }
  .box {
  background-color: #fbfbfb;
  border: 1px solid #AAA;
  border-bottom: 1px solid #888;
  border-radius: 3px;
  color: black;
  box-shadow: 0px 2px 2px #AAA;
  padding: 20px;
  font-size:1.5em;
}
.back {display:inline-block;padding:5px 15px;background:gray;color:#fff;font-size:1.5em;}
  </style>
</head>

<body>

  <div class="container">
    <div class="box">
      <?php echo nl2br($errors); ?>
      <br><br>
      <a class="back" href="javascript:history.back()">Go Back</a>
    </div>
  </div>
  </body>
</html>
